/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.block.cable.inputfilter;

import com.google.common.collect.Lists;
import com.lothrazar.storagenetwork.api.IGuiPrivate;
import com.lothrazar.storagenetwork.api.OpCompareType;
import com.lothrazar.storagenetwork.block.cable.inputfilter.ContainerCableImportFilter;
import com.lothrazar.storagenetwork.capability.handler.FilterItemStackHandler;
import com.lothrazar.storagenetwork.gui.ButtonRequest;
import com.lothrazar.storagenetwork.gui.ItemSlotNetwork;
import com.lothrazar.storagenetwork.gui.TextboxInteger;
import com.lothrazar.storagenetwork.network.CableIOMessage;
import com.lothrazar.storagenetwork.registry.ClientEventRegistry;
import com.lothrazar.storagenetwork.registry.PacketRegistry;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class ScreenCableImportFilter
extends AbstractContainerScreen<ContainerCableImportFilter>
implements IGuiPrivate {
    private final ResourceLocation texture = new ResourceLocation("storagenetwork", "textures/gui/cable_filter.png");
    ContainerCableImportFilter containerCableLink;
    private ButtonRequest btnRedstone;
    private ButtonRequest btnMinus;
    private ButtonRequest btnPlus;
    private ButtonRequest btnAllowIgn;
    private ButtonRequest btnImport;
    private boolean isAllowlist;
    private List<ItemSlotNetwork> itemSlotsGhost;
    private ButtonRequest btnOperationToggle;
    private ItemSlotNetwork operationItemSlot;
    private TextboxInteger txtHeight;
    public static final int SLOT_SIZE = 18;

    public ScreenCableImportFilter(ContainerCableImportFilter containerCableFilter, Inventory inv, Component name) {
        super((AbstractContainerMenu)containerCableFilter, inv, name);
        this.containerCableLink = containerCableFilter;
    }

    @Override
    public void renderStackTooltip(PoseStack ms, ItemStack stack, int mousex, int mousey) {
        super.m_6057_(ms, stack, mousex, mousey);
    }

    @Override
    public void drawGradient(PoseStack ms, int x, int y, int x2, int y2, int u, int v) {
        super.m_93179_(ms, x, y, x2, y2, u, v);
    }

    public void m_7856_() {
        super.m_7856_();
        this.isAllowlist = this.containerCableLink.cap.getFilter().isAllowList;
        this.btnRedstone = (ButtonRequest)this.m_142416_((GuiEventListener)new ButtonRequest(this.f_97735_ + 4, this.f_97736_ + 4, "", p -> {
            this.syncData(0);
            PacketRegistry.INSTANCE.sendToServer((Object)new CableIOMessage(CableIOMessage.CableMessageType.REDSTONE.ordinal()));
        }));
        this.btnMinus = (ButtonRequest)this.m_142416_((GuiEventListener)new ButtonRequest(this.f_97735_ + 22, this.f_97736_ + 4, "", p -> this.syncData(-1)));
        this.btnMinus.setTextureId(ButtonRequest.TextureEnum.MINUS);
        this.btnPlus = (ButtonRequest)this.m_142416_((GuiEventListener)new ButtonRequest(this.f_97735_ + 60, this.f_97736_ + 4, "", p -> this.syncData(1)));
        this.btnPlus.setTextureId(ButtonRequest.TextureEnum.PLUS);
        this.btnAllowIgn = (ButtonRequest)this.m_142416_((GuiEventListener)new ButtonRequest(this.f_97735_ + 152, this.f_97736_ + 24, "", p -> {
            this.isAllowlist = !this.isAllowlist;
            this.syncData(0);
        }));
        this.btnImport = (ButtonRequest)this.m_142416_((GuiEventListener)new ButtonRequest(this.f_97735_ + 80, this.f_97736_ + 4, "", p -> PacketRegistry.INSTANCE.sendToServer((Object)new CableIOMessage(CableIOMessage.CableMessageType.IMPORT_FILTER.ordinal()))));
        this.btnImport.setTextureId(ButtonRequest.TextureEnum.IMPORT);
        this.txtHeight = new TextboxInteger(this.f_96547_, this.f_97735_ + 48, this.f_97736_ + 26, 36);
        this.txtHeight.m_94199_(4);
        this.txtHeight.m_94144_("" + this.containerCableLink.cap.operationLimit);
        this.m_142416_((GuiEventListener)this.txtHeight);
        this.btnOperationToggle = (ButtonRequest)this.m_142416_((GuiEventListener)new ButtonRequest(this.f_97735_ + 29, this.f_97736_ + 26, "=", p -> {
            OpCompareType old = OpCompareType.get(this.containerCableLink.cap.operationType);
            this.containerCableLink.cap.operationType = old.toggle().ordinal();
            PacketRegistry.INSTANCE.sendToServer((Object)new CableIOMessage(CableIOMessage.CableMessageType.SYNC_OP.ordinal(), this.containerCableLink.cap.operationType, false));
        }));
        this.btnOperationToggle.f_93624_ = false;
        this.txtHeight.f_93624_ = false;
    }

    public void m_7027_(PoseStack ms, int mouseX, int mouseY) {
        int priority = this.containerCableLink.cap.getPriority();
        this.f_96547_.m_92883_(ms, String.valueOf(priority), (float)(50 - this.f_96547_.m_92895_(String.valueOf(priority)) / 2), 12.0f, 0x404040);
        if (this.btnOperationToggle != null && this.isOperationMode()) {
            OpCompareType t = OpCompareType.get(this.containerCableLink.cap.operationType);
            this.btnOperationToggle.m_93666_((Component)new TextComponent(t.symbol()));
        }
        this.drawTooltips(ms, mouseX, mouseY);
    }

    private void sendStackSlot(int value, ItemStack stack) {
        PacketRegistry.INSTANCE.sendToServer((Object)new CableIOMessage(CableIOMessage.CableMessageType.SAVE_FITLER.ordinal(), value, stack));
    }

    private void syncData(int priority) {
        this.containerCableLink.cap.getFilter().isAllowList = this.isAllowlist;
        PacketRegistry.INSTANCE.sendToServer((Object)new CableIOMessage(CableIOMessage.CableMessageType.SYNC_DATA.ordinal(), priority, this.isAllowlist));
    }

    public void m_6305_(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(ms);
        super.m_6305_(ms, mouseX, mouseY, partialTicks);
        this.m_7025_(ms, mouseX, mouseY);
        if (this.containerCableLink == null || this.containerCableLink.cap == null) {
            return;
        }
        this.btnAllowIgn.setTextureId(this.isAllowlist ? ButtonRequest.TextureEnum.ALLOWLIST : ButtonRequest.TextureEnum.IGNORELIST);
        this.btnRedstone.setTextureId(this.containerCableLink.cap.needsRedstone() ? ButtonRequest.TextureEnum.REDSTONETRUE : ButtonRequest.TextureEnum.REDSTONEFALSE);
        this.txtHeight.f_93624_ = this.btnOperationToggle.f_93623_ = (this.btnOperationToggle.f_93624_ = this.isOperationMode());
        if (this.btnOperationToggle.f_93624_) {
            // empty if block
        }
    }

    private boolean isOperationMode() {
        return this.containerCableLink.cap.isOperationMode();
    }

    private void drawTooltips(PoseStack ms, int mouseX, int mouseY) {
        if (this.btnImport != null && this.btnImport.m_5953_(mouseX, mouseY)) {
            this.m_169388_(ms, Lists.newArrayList((Object[])new Component[]{new TranslatableComponent("gui.storagenetwork.import")}), Optional.empty(), mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
        if (this.btnAllowIgn != null && this.btnAllowIgn.m_5953_(mouseX, mouseY)) {
            this.m_169388_(ms, Lists.newArrayList((Object[])new Component[]{new TranslatableComponent(this.isAllowlist ? "gui.storagenetwork.allowlist" : "gui.storagenetwork.ignorelist")}), Optional.empty(), mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
        if (this.btnMinus != null && this.btnMinus.m_5953_(mouseX, mouseY)) {
            this.m_169388_(ms, Lists.newArrayList((Object[])new Component[]{new TranslatableComponent("gui.storagenetwork.priority.down")}), Optional.empty(), mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
        if (this.btnPlus != null && this.btnPlus.m_5953_(mouseX, mouseY)) {
            this.m_169388_(ms, Lists.newArrayList((Object[])new Component[]{new TranslatableComponent("gui.storagenetwork.priority.up")}), Optional.empty(), mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
        if (this.btnRedstone != null && this.btnRedstone.m_5953_(mouseX, mouseY)) {
            this.m_169388_(ms, Lists.newArrayList((Object[])new Component[]{new TranslatableComponent("gui.storagenetwork.redstone." + this.containerCableLink.cap.needsRedstone())}), Optional.empty(), mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
        if (this.btnOperationToggle != null && this.btnOperationToggle.m_5953_(mouseX, mouseY)) {
            OpCompareType t = OpCompareType.get(this.containerCableLink.cap.operationType);
            String two = "gui.storagenetwork.operate.tooltip." + t.word();
            this.m_169388_(ms, Lists.newArrayList((Object[])new Component[]{new TranslatableComponent("gui.storagenetwork.operate.tooltip"), new TranslatableComponent(two)}), Optional.empty(), mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
    }

    protected void m_7286_(PoseStack ms, float partialTicks, int mouseX, int mouseY) {
        int x;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
        int xCenter = (this.f_96543_ - this.f_97726_) / 2;
        int yCenter = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(ms, xCenter, yCenter, 0, 0, this.f_97726_, this.f_97727_);
        this.itemSlotsGhost = Lists.newArrayList();
        int rows = 2;
        int cols = 9;
        int index = 0;
        int y = 45;
        for (int row = 0; row < 2; ++row) {
            for (int col = 0; col < 9; ++col) {
                ItemStack stack = this.containerCableLink.cap.getFilter().getStackInSlot(index);
                x = 8 + col * 18;
                this.itemSlotsGhost.add(new ItemSlotNetwork(this, stack, this.f_97735_ + x, this.f_97736_ + y, stack.m_41613_(), this.f_97735_, this.f_97736_, true));
                ++index;
            }
            y += 18;
        }
        x = this.f_97735_ + 6;
        y = this.f_97736_ + 26;
        for (ItemSlotNetwork s : this.itemSlotsGhost) {
            s.drawSlot(ms, this.f_96547_, mouseX, mouseY);
        }
        int size = 18;
        this.operationItemSlot = new ItemSlotNetwork(this, this.containerCableLink.cap.operationStack, x, y, size, this.f_97735_, this.f_97736_, false);
        if (this.isOperationMode()) {
            this.operationItemSlot.drawSlot(ms, this.f_96547_, mouseX, mouseY);
            RenderSystem.m_157456_((int)0, (ResourceLocation)ClientEventRegistry.SLOT);
            ScreenCableImportFilter.m_93133_((PoseStack)ms, (int)(x - 1), (int)(y - 1), (float)0.0f, (float)0.0f, (int)size, (int)size, (int)size, (int)size);
        }
    }

    public void setFilterItems(List<ItemStack> stacks) {
        FilterItemStackHandler filter = this.containerCableLink.cap.getFilter();
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack s = stacks.get(i);
            filter.setStackInSlot(i, s);
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (delta != 0.0) {
            for (int i = 0; i < this.itemSlotsGhost.size(); ++i) {
                ItemStack changeme;
                ItemSlotNetwork slot = this.itemSlotsGhost.get(i);
                if (!slot.isMouseOverSlot((int)mouseX, (int)mouseY) || (changeme = ScreenCableImportFilter.scrollStack(delta, slot)) == null) continue;
                this.sendStackSlot(i, changeme);
                return true;
            }
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public static ItemStack scrollStack(double delta, ItemSlotNetwork slot) {
        ItemStack changeme = slot.getStack().m_41777_();
        int dir = delta > 0.0 ? 1 : -1;
        changeme.m_41769_(dir);
        if (changeme.m_41613_() > 64) {
            changeme.m_41764_(64);
        }
        if (changeme.m_41613_() > 0 && changeme.m_41613_() != slot.getStack().m_41613_()) {
            slot.setStack(changeme);
            return changeme;
        }
        return null;
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        ItemStack stackCarriedByMouse = this.f_96541_.f_91074_.f_36096_.m_142621_();
        if (this.operationItemSlot.isMouseOverSlot((int)mouseX, (int)mouseY)) {
            PacketRegistry.INSTANCE.sendToServer((Object)new CableIOMessage(CableIOMessage.CableMessageType.SYNC_OP_STACK.ordinal(), stackCarriedByMouse.m_41777_()));
            return true;
        }
        for (int i = 0; i < this.itemSlotsGhost.size(); ++i) {
            ItemSlotNetwork slot = this.itemSlotsGhost.get(i);
            if (!slot.isMouseOverSlot((int)mouseX, (int)mouseY)) continue;
            if (!slot.getStack().m_41619_()) {
                if (mouseButton == 1) {
                    int direction = ScreenCableImportFilter.m_96638_() ? -1 : 1;
                    int newCount = Math.min(64, slot.getStack().m_41613_() + direction);
                    if (newCount < 1) {
                        newCount = 1;
                    }
                    slot.getStack().m_41764_(newCount);
                } else {
                    slot.setStack(ItemStack.f_41583_);
                }
                this.sendStackSlot(i, slot.getStack());
                return true;
            }
            slot.setStack(stackCarriedByMouse.m_41777_());
            this.sendStackSlot(i, stackCarriedByMouse.m_41777_());
            return true;
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean isInRegion(int x, int y, int width, int height, double mouseX, double mouseY) {
        return super.m_6774_(x, y, width, height, mouseX, mouseY);
    }
}

